package chess4j.pieces;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import chess4j.Color;
import chess4j.board.directions.Direction;



public abstract class SlidingPiece extends Piece {

	protected List<Direction> _dirs = new ArrayList<Direction>();
	protected abstract void addDirections();
	
	public SlidingPiece(Color c) {
		super(c);
		addDirections();
	}	
	
	public List<Direction> getDirections() {
		return Collections.unmodifiableList(_dirs);
	}
}
